<?php

namespace vipnytt\SitemapParser\Tests;

use PHPUnit\Framework\TestCase;
use vipnytt\SitemapParser;

class StripCommentsTest extends TestCase
{
    /**
     * @dataProvider generateDataForTest
     * @param string $url URL
     * @param string $body URL body content
     */
    public function testStrict($url, $body)
    {
        $parser = new SitemapParser();
        $this->assertInstanceOf('vipnytt\SitemapParser', $parser);
        $parser->parse($url, $body);
        $this->assertEquals([
            'https://www.bellinghambaymarathon.org/post-sitemap.xml' => [
                'loc' => 'https://www.bellinghambaymarathon.org/post-sitemap.xml',
                'lastmod' => '2019-07-19T10:18:07-07:00',
                'namespaces'=> [],
            ],
            'https://www.bellinghambaymarathon.org/page-sitemap.xml' => [
                'loc' => 'https://www.bellinghambaymarathon.org/page-sitemap.xml',
                'lastmod' => '2019-07-29T06:51:35-07:00',
                'namespaces'=> [],
            ],
            'https://www.bellinghambaymarathon.org/category-sitemap.xml' => [
                'loc' => 'https://www.bellinghambaymarathon.org/category-sitemap.xml',
                'lastmod' => '2019-07-19T10:18:07-07:00',
                'namespaces'=> [],
            ],
            'https://www.bellinghambaymarathon.org/post_tag-sitemap.xml' => [
                'loc' => 'https://www.bellinghambaymarathon.org/post_tag-sitemap.xml',
                'lastmod' => '2019-05-16T10:06:14-07:00',
                'namespaces'=> [],
            ],
            'https://www.bellinghambaymarathon.org/author-sitemap.xml' => [
                'loc' => 'https://www.bellinghambaymarathon.org/author-sitemap.xml',
                'lastmod' => '2018-08-22T17:12:52-07:00',
                'namespaces'=> [],
            ],
        ], $parser->getSitemaps());
        $this->assertEquals([], $parser->getURLs());
    }

    /**
     * Generate test data
     * @return array
     */
    public function generateDataForTest()
    {
        return [
            [
                'https://www.bellinghambaymarathon.org/sitemap_index.xml',
                <<<TEXT
<!-- This page is cached by the Hummingbird Performance plugin v2.0.1 - https://wordpress.org/plugins/hummingbird-performance/. -->
<?xml version="1.0" encoding="UTF-8"?>
	<?xml-stylesheet type="text/xsl" href="//www.bellinghambaymarathon.org/main-sitemap.xsl"?>
		<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
			<sitemap>
				<loc>https://www.bellinghambaymarathon.org/post-sitemap.xml</loc>
				<lastmod>2019-07-19T10:18:07-07:00</lastmod>
			</sitemap>
			<sitemap>
				<loc>https://www.bellinghambaymarathon.org/page-sitemap.xml</loc>
				<lastmod>2019-07-29T06:51:35-07:00</lastmod>
			</sitemap>
			<sitemap>
				<loc>https://www.bellinghambaymarathon.org/category-sitemap.xml</loc>
				<lastmod>2019-07-19T10:18:07-07:00</lastmod>
			</sitemap>
			<sitemap>
				<loc>https://www.bellinghambaymarathon.org/post_tag-sitemap.xml</loc>
				<lastmod>2019-05-16T10:06:14-07:00</lastmod>
			</sitemap>
			<sitemap>
				<loc>https://www.bellinghambaymarathon.org/author-sitemap.xml</loc>
				<lastmod>2018-08-22T17:12:52-07:00</lastmod>
			</sitemap>
		</sitemapindex>
<!-- XML Sitemap generated by Yoast SEO --><!-- Hummingbird cache file was created in 1.061126947403 seconds, on 01-08-19 23:06:50 -->
TEXT
            ]
        ];
    }
}
