<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We want to salute you and welcome you to our website community!<br /><br /><a href="{{URL}}">Visit our homepage</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'A user just deleted his account from the website!<br /><br />All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.websites_limit' => '%s websites',
    'global.plan_settings.audits_per_month_limit' => '%s audits / month',
    'global.plan_settings.audits_bulk_limit' => '%s audits in bulk',
    'global.plan_settings.audits_enabled_tests' => '%s audit tests',
    'global.plan_settings.audits_check_intervals' => 'Automated audits',
    'global.plan_settings.audits_retention' => '%s days audits retention',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.password_protection_is_enabled' => 'Password protection',
    'global.plan_settings.password_protection_is_enabled_help' => 'Your audits can be password protected if needed.',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.removable_branding_is_enabled' => 'Removable branding',
    'global.plan_settings.removable_branding_is_enabled_help' => 'All the branding will be removed from branded resources.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.notification_handlers_limit' => 'Multiple notification handlers',
    'global.plan_settings.notification_handlers_email_limit' => '%s email handlers',
    'global.plan_settings.notification_handlers_webhook_limit' => '%s webhook handlers',
    'global.plan_settings.notification_handlers_slack_limit' => '%s Slack handlers',
    'global.plan_settings.notification_handlers_discord_limit' => '%s Discord handlers',
    'global.plan_settings.notification_handlers_microsoft_teams_limit' => '%s Microsoft Teams handlers',
    'global.plan_settings.notification_handlers_twilio_limit' => '%s SMS handlers',
    'global.plan_settings.notification_handlers_twilio_call_limit' => '%s Phone call handlers',
    'global.plan_settings.notification_handlers_telegram_limit' => '%s Telegram handlers',
    'global.plan_settings.notification_handlers_whatsapp_limit' => '%s Whatsapp handlers',
    'global.plan_settings.notification_handlers_x_limit' => '%s X handlers',
    'global.plan_settings.notification_handlers_push_subscriber_id_limit' => '%s Push subscribers handlers',

    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.subheader.desktop' => 'Click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'Tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'Tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'Click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Get to learn & understand new things with the help of curated your blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',
    'plan.button.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.input.default_results_per_page' => 'Default results per page',
    'account_preferences.input.default_order_type' => 'Default results order',
    'account_preferences.input.default_order_by_x' => '%s default order by',
    'account_preferences.input.white_label_title' => 'White label title',
    'account_preferences.input.white_label_logo_light' => 'White label logo light',
    'account_preferences.input.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.input.white_label_favicon' => 'White label favicon',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',

    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payments.payment_processor' => 'Processor',
    'account_payments.payments.total_amount' => 'Total amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments found',

    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.input.access' => '%s permissions',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',

    'login.form.twofa_token' => 'Two-factor token',
    'login.form.remember_me' => 'Remember me',
    'login.form.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.form.login' => 'Login',
    'login.form.verify' => 'Verify',

    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost password',
    'login.display.resend_activation' => 'Resend activation',
    'login.display.facebook' => 'Sign in with Facebook',
    'login.display.google' => 'Sign in with Google',
    'login.display.twitter' => 'Sign in with X',
    'login.display.discord' => 'Sign in with Discord',
    'login.display.linkedin' => 'Sign in with LinkedIn',
    'login.display.microsoft' => 'Sign in with Microsoft',

    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',

    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.form.register' => 'Register',

    'register.display.login' => 'Already have an account? %s',
    'register.display.login_help' => 'Sign in',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'Check your email for the activation link of your account.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.websites_header' => 'Latest websites',
    'dashboard.audits_header' => 'Latest audits',
    'dashboard.total_websites' => '%s websites',
    'dashboard.total_audits' => '%s audits this month',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Instant SEO Professional Audits',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'SEO Audits & Tools',
    'index.subheader' => 'Get your webpages audited professionally and improve your SEO in minutes.',
    'index.audit' => 'Generate SEO Audit',
    'index.register' => 'Sign up',
    'index.example' => 'Audit sample',
    'index.hero_image_alt' => 'Screenshot of the app dashboard',
    'index.audit_form_image_alt' => 'Screenshot of the app audit generator form',
    'index.audit_history_image_alt' => 'Screenshot of the app audit history tracking feature',
    'index.audit_tests_image_alt' => 'Screenshot of the app audit generated tests',
    'index.public_audits_image_alt' => 'Screenshot of the public app audit page',
    'index.password_audits_image_alt' => 'Screenshot of the password protection audit page feature',
    'index.recurring_audits_image_alt' => 'Screenshot of the recurring auditing feature of the app',
    'index.export_audits_image_alt' => 'Screenshot of the app CSV, PDF, CSV exporting features',
    'index.api_image_alt' => 'Screenshot of the app API endpoints feature',
    'index.domains_image_alt' => 'Screenshot of the app custom domains feature for audits',

    'index.generate_audit.name' => 'SEO Audits',
    'index.generate_audit.header' => 'Audit any type of webpage',
    'index.generate_audit.subheader' => 'Versatile, easy to use & modular checks.',
    'index.generate_audit.single' => 'Audit <strong>single URL</strong> webpages',
    'index.generate_audit.sitemap' => 'Check all pages within a <strong>sitemap</strong>',
    'index.generate_audit.bulk' => '<strong>Bulk</strong> webpages SEO checking',
    'index.generate_audit.html' => '<strong>Raw HTML</strong> auditing',

    'index.audit.name' => 'Professional audit',
    'index.audit.header' => 'Advanced analysis of SEO',
    'index.audit.subheader' => 'Your complete SEO checklist before going live with a page.',
    'index.audit.one' => '<strong>40+ tests</strong> with easy to understand solutions',
    'index.audit.two' => 'Overall SEO Health score checks',
    'index.audit.three' => 'Critical issues to fix',
    'index.audit.four' => 'Page speed & performance metrics',
    'index.audit.five' => 'Content quality & media insights',
    'index.audit.six' => 'On page technical SEO',

    'index.archived_audits.name' => 'Archived audits',
    'index.archived_audits.header' => 'Auditing history',
    'index.archived_audits.subheader' => 'Keep & verify all details of your old audits.',
    'index.archived_audits.one' => 'Track your SEO performance against old audits',
    'index.archived_audits.two' => 'Identify recurring issues in your website',
    'index.archived_audits.three' => 'Easily spot regressions or new issues',
    'index.archived_audits.four' => 'Measure the impact of SEO strategies over time',

    'index.tools.header' => '%s additional tools',
    'index.tools.subheader' => 'Web & SEO tools. Fast, reliable and easy to use.',

    'index.tests.header' => '40+ SEO tests',

    'index.tutorial.one' => 'Paste your URL.',
    'index.tutorial.one_text' => 'Single page, bulk, sitemap or raw HTML.',
    'index.tutorial.two' => 'Run the audit.',
    'index.tutorial.two_text' => 'Get effective insights in seconds.',
    'index.tutorial.three' => 'Fix issues & improve.',
    'index.tutorial.three_text' => 'Get actionable tips to improve your SEO',

    'index.steps.one' => 'Fast & accurate.',
    'index.steps.one_text' => 'Get modern & precise audits within seconds.',
    'index.steps.two' => 'SEO done right.',
    'index.steps.two_text' => 'Powerful technical SEO made easy.',
    'index.steps.three' => 'We respect your data.',
    'index.steps.three_text' => 'Yours always. Deletable anytime.',

    'index.public_audits.header' => 'Sharable audits',
    'index.public_audits.subheader' => 'Copy and paste the URL to the audit. It\'s that easy.',

    'index.password_protection.header' => 'Password protection',
    'index.password_protection.subheader' => 'Make your audit accessible only to those with the password.',

    'index.audit_refresh.header' => 'Scheduled & recurring audits',
    'index.audit_refresh.subheader' => 'Automate your audits and get notified when something changes.',

    'index.domains.header' => 'Custom domains',
    'index.domains.subheader' => 'Connect your own domain to brand your audit sharable links.',

    'index.api.header' => 'API ready',
    'index.api.subheader' => 'Developer ready to seamlessly integrate via code.',

    'index.export.header' => 'Data export',
    'index.export.subheader' => 'Export your data to CSV, JSON or PDF with a click of a button.',

    'index.stats' => 'We\'ve done <span class=\'text-primary-400\'>%1$s+ audits</span> for more than <span class=\'text-primary-400\'>%2$s+ domains</span>.',

    'index.notifications_handlers.header' => 'Get notified on audit refreshes',
    'index.notifications_handlers.subheader' => 'Countless notification integrations for all your needs.',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Blazing fast SEO audits for webpages.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',
    'api_documentation.notification_handlers' => 'Notification handlers',
    'api_documentation.notifications_handlers_ids' => 'Notification handler ids',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',

    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',


    'websites.title' => 'Websites',
    'websites.menu' => 'Websites',
    'websites.breadcrumb' => 'Websites',
    'websites.header' => 'Websites',
    'websites.subheader' => 'All the domains you have audited.',
    'websites.create' => 'Add website',
    'websites.no_data' => 'There are no websites audited',
    'websites.no_data_help' => 'Start by auditing your first webpage.',
    'websites.website' => 'Website',
    'websites.host' => 'Domain or subdomain',
    'websites.total_audits' => 'Total audits',
    'websites.total_archived_audits' => 'Total archived audits',
    'websites.total_audits_x' => '%s audits',
    'websites.total_archived_audits_x' => '%s archived audits',
    'websites.last_audit_datetime' => 'Last audited',
    'websites.dynamic_description' => 'This website has an average SEO score of <strong>%1$s out of 100</strong>. We have also identified a total of <strong>%2$s issues</strong> across <strong>%3$s audits</strong>.',


    'website.title' => 'Website - %s',
    'website.menu' => 'Website',
    'website.breadcrumb' => 'Website',
    'website.header' => '%s',
    'website.subheader' => 'Here are all the details about your website.',


    'website_update.breadcrumb' => 'Edit website',
    'website_update.title' => 'Edit website',
    'website_update.header' => 'Edit website',
    'website_update.info_message' => 'Updating the website settings will automatically apply them to all audits from this website.',


    'archived_audits.title' => 'Archived audits',
    'archived_audits.menu' => 'Archived audits',
    'archived_audits.breadcrumb' => 'Archived audits',
    'archived_audits.header' => 'Archived audits',
    'archived_audits.subheader' => 'All the archived audits of your webpages.',
    'archived_audits.no_data' => 'There are no archived audits',
    'archived_audits.no_data_help' => 'Here you will see old versions of your main audits.',


    'archived_audit.title' => 'Archived audit - %s',
    'archived_audit.menu' => 'Archived audit',
    'archived_audit.breadcrumb' => 'Archived audit',
    'archived_audit.header' => '%s',


    'audits.title' => 'Audits',
    'audits.menu' => 'Audits',
    'audits.breadcrumb' => 'Audits',
    'audits.header' => 'Audits',
    'audits.subheader' => 'All the webpages audits.',
    'audits.create' => 'Generate audit',
    'audits.no_data' => 'There are no generated audits',
    'audits.no_data_help' => 'Start by running your first audit.',
    'audits.open' => 'Open URL',
    'audits.submit' => 'Start audit',
    'audits.audits' => 'Audits',
    'audits.audit' => 'Audit',
    'audits.settings' => 'Settings',
    'audits.last_refresh_datetime' => 'Last refresh',
    'audits.next_refresh_datetime' => 'Next refresh',
    'audits.score' => 'Score',
    'audits.total_issues' => 'Issues',
    'audits.total_issues_x' => '%s issues',
    'audits.major_issues_x' => '%s major issues',
    'audits.major_issue' => 'Major issue',
    'audits.major_issues' => 'Major issues',
    'audits.moderate_issues_x' => '%s moderate issues',
    'audits.moderate_issue' => 'Moderate issue',
    'audits.moderate_issues' => 'Moderate issues',
    'audits.minor_issues_x' => '%s minor issues',
    'audits.minor_issue' => 'Minor issue',
    'audits.minor_issues' => 'Minor issues',
    'audits.passed_tests_x' => '%s passed tests',
    'audits.passed_test' => 'Passed test',
    'audits.passed_tests' => 'Passed tests',
    'audits.informational_test' => 'Informational test',
    'audits.host' => 'Domain',
    'audits.total_refreshes' => 'Total refreshes',
    'audits.page_title' => 'Page title',
    'audits.refresh' => 'Refresh audit',
    'audits.main_audit' => 'View main audit',
    'audits.dynamic_description' => 'This webpage has received an SEO score of <strong>%1$s out of 100</strong>. We have also identified a total of <strong>%2$s issues</strong>, <strong>%3$s passed tests</strong> based on <strong>%4$s total tests</strong>.',
    'audits.ttfb' => 'TTFB',
    'audits.ttfb_help' => 'Time to first byte',
    'audits.ttfb_help2' => 'TTFB measures the time from an HTTP request to the first byte received by the browser.',
    'audits.response_time' => 'Response time',
    'audits.response_time_help' => 'Total time taken to complete the entire request, from connecting to receiving the response.',
    'audits.page_size' => 'Page size',
    'audits.page_size_help' => 'Total size of the page source code downloaded, excluding headers, external resources (images or scripts) and without compression.',
    'audits.opengraph_image' => 'Opengraph image',
    'audits.http_requests_x' => '%s requests',
    'audits.http_requests' => 'HTTP Requests',
    'audits.http_requests_help' => 'Images, Scripts, Stylesheets, Iframes, Videos, Audios are calculated as HTTP requests.',
    'audits.meta_description_missing' => 'Meta description is missing.',
    'audits.characters' => '%s characters',
    'audits.request_help' => 'All requests will come from our %1$s IP and will have the %2$s user agent.',

    'audits.email_report.subject' => '\'%1$s\' domain audit refresh (%2$s%% score) - {{WEBSITE_TITLE}}',
    'audits.email_report.p1' => '\'%1$s\' has been audited automatically.',
    'audits.email_report.button' => 'View audit',
    'audits.email_report.notice' => 'You’re receiving this email because email reports are enabled.<br /> You can unsubscribe anytime on the %saudit update%s page',

    'audits.basic' => 'Basic document setup',
    'audits.seo' => 'On-page SEO',
    'audits.content' => 'Content quality & markup',
    'audits.media' => 'Media & image optimization',
    'audits.technical_performance' => 'Technical & performance factors',
    'audits.links' => 'Links',

    'audits.test.title' => 'Title',
    'audits.test.title.missing' => 'Title tag is missing.',
    'audits.test.title.missing_help' => 'It is important to have a page title. Make sure to add one with 50-60 characters.',
    'audits.test.title.too_long' => 'Title is too long.',
    'audits.test.title.too_long_help' => 'It is recommended to keep your title between 50-60 characters.',
    'audits.test.title.too_short' => 'Title is too short.',
    'audits.test.title.too_short_help' => 'It is recommended to have at least 30 characters in your title. Ideally between 50-60 characters.',

    'audits.test.meta_description' => 'Meta description',
    'audits.test.meta_description.missing' => 'Meta description tag is missing.',
    'audits.test.meta_description.missing_help' => 'It is important to have a meta description on your page. Make sure to add one with 50-160 characters.',
    'audits.test.meta_description.too_long' => 'Meta description is too long.',
    'audits.test.meta_description.too_long_help' => 'It is recommended to keep your meta description between 50-160 characters.',
    'audits.test.meta_description.too_short' => 'Meta description is too short.',
    'audits.test.meta_description.too_short_help' => 'It is recommended to have at least 50 characters in your meta description. Ideally between 50-160 characters.',

    'audits.test.h1' => 'H1 tag',
    'audits.test.h1.missing' => 'H1 tag is missing.',
    'audits.test.h1.missing_help' => 'It is important to have one H1 heading tag on your page. Make sure to add one with 50± characters.',
    'audits.test.h1.too_many' => 'Too many H1 tags.',
    'audits.test.h1.too_many_help' => 'It is significant to have only one H1 heading tag on your page.',
    'audits.test.h1.too_long' => 'H1 tag is too long.',
    'audits.test.h1.too_long_help' => 'It is trivial to keep your H1 tag between 10-120 characters.',
    'audits.test.h1.too_short' => 'H1 tag is too short.',
    'audits.test.h1.too_short_help' => 'It is trivial to have at least 10 characters in your H1 tag. Ideally between 10-120 characters.',

    'audits.test.meta_keywords' => 'Meta keywords',
    'audits.test.meta_keywords_count' => '%s keywords',
    'audits.test.meta_keywords.missing' => 'Meta keywords are missing.',
    'audits.test.meta_keywords.missing_help' => 'Meta keywords are no longer relevant for Google SEO; however, other search engines, such as Baidu and Yandex, still consider them.',

    'audits.test.not_found' => '404 page',
    'audits.test.not_found_help' => 'We tested your site against a randomized URL on your webpage so that we can validate if your site returns a 404 status code.',
    'audits.test.not_found.missing' => '404 valid pages are not implemented.',
    'audits.test.not_found.missing_help' => 'A page that does not exist on your website should return a valid 404 status code.',

    'audits.test.robots' => 'robots.txt page',
    'audits.test.robots_help' => 'We tested your site for the robots page existence, it\'s validity & exclusion rules.',
    'audits.test.robots.missing' => 'robots.txt page is not implemented.',
    'audits.test.robots.missing_help' => 'The robots.txt file can tell crawlers which pages can be accessed or not. If you don\'t have one, all public pages within your website will be crawled.',
    'audits.test.robots.excluded' => 'Page is excluded from crawling.',
    'audits.test.robots.excluded_help' => 'The robots.txt directives have excluded this page from being crawled by bots.',

    'audits.test.language' => 'Language attribute',
    'audits.test.language_help' => 'The language attribute tells browsers and search engines your webpage’s main language, improving accessibility and accuracy.',
    'audits.test.language.missing' => 'Language attribute is missing.',
    'audits.test.language.missing_help' => 'Make sure to implement the <code>lang</code> attribute in your <code>&lt;html&gt;</code> tag by using an ISO 639-1 language code.',

    'audits.test.favicon' => 'Favicon',
    'audits.test.favicon_help' => 'The favicon is a small icon that represents your website in browser tabs, bookmarks, and search results, improving branding and user recognition.',
    'audits.test.favicon.missing' => 'Favicon is missing.',
    'audits.test.favicon.missing_help' => 'Make sure to add a favicon by linking a small icon file in your <code>&lt;head&gt;</code> section using the <code>&lt;link&gt;</code> tag.',

    'audits.test.meta_robots' => 'Meta robots',
    'audits.test.meta_robots_missing' => 'No meta robots tags have been used.',
    'audits.test.meta_robots_help' => 'We tested your webpage for the <strong>noindex</strong> and <strong>none</strong> properties on the meta robots tag. They should not be included in your webpage to avoid being excluded from search engines.',
    'audits.test.meta_robots.excluded' => 'Page is excluded from indexing.',
    'audits.test.meta_robots.excluded_help' => 'Make sure to remove the <strong>noindex</strong> and <strong>none</strong> properties to allow search engines to index your webpage.',

    'audits.test.header_robots' => 'Header robots',
    'audits.test.header_robots_missing' => 'No robots header tag has been used.',
    'audits.test.header_robots_help' => 'We tested your webpage for the <strong>noindex</strong> and <strong>none</strong> properties on the <code>X-Robots-Tag</code> header. This header tag should not be included in your webpage to avoid being excluded from search engines.',
    'audits.test.header_robots.excluded' => 'Page is excluded from indexing.',
    'audits.test.header_robots.excluded_help' => 'Make sure to remove the <strong>noindex</strong> and <strong>none</strong> properties from the <code>X-Robots-Tag</code> header tag to allow search engines to index your webpage.',

    'audits.test.response_time' => 'Response time',
    'audits.test.response_time_help' => 'Response time is crucial for SEO; faster pages improve rankings, user experience, and reduce bounce rates.',
    'audits.test.response_time.too_slow' => 'Response time is too slow.',
    'audits.test.response_time.too_slow_help' => 'It is important to keep your response time below 2 seconds.',

    'audits.test.page_size' => 'Page size',
    'audits.test.page_size_help' => 'A smaller page HTML size ensures faster initial page load, improving user experience, reducing server load & bandwidth, and boosting SEO rankings.',
    'audits.test.page_size.too_big' => 'Page size is too big.',
    'audits.test.page_size.too_big_help' => 'It is recommended to keep your page size below 150 kB (kilobytes).',

    'audits.test.dom_size' => 'DOM size',
    'audits.test.dom_size_nodes' => '%s nodes',
    'audits.test.dom_size_help' => 'A smaller DOM size ensures faster rendering, smoother interactivity, and better performance, especially on resource-limited devices.',
    'audits.test.dom_size.too_big' => 'DOM size is too big.',
    'audits.test.dom_size.too_big_help' => 'It is recommended to keep your DOM size below 1,500 nodes.',

    'audits.test.meta_viewport' => 'Meta viewport',
    'audits.test.meta_viewport_help' => 'The meta viewport tag ensures your website adapts to different screen sizes, improving mobile usability and user experience, which are crucial for SEO and engagement.',
    'audits.test.meta_viewport.missing' => 'Meta viewport tag is missing.',
    'audits.test.meta_viewport.missing_help' => 'Make sure to add a meta viewport tag in your <code>&lt;head&gt;</code> section using the <code>&lt;meta name="viewport" content="width=device-width, initial-scale=1"&gt;</code> tag to ensure proper display on all devices.',

    'audits.test.meta_charset' => 'Meta charset',
    'audits.test.meta_charset_help' => 'The meta charset tag ensures your website uses the correct character encoding, preventing broken or garbled text and improving user experience.',
    'audits.test.meta_charset.missing' => 'Meta charset tag is missing.',
    'audits.test.meta_charset.missing_help' => 'Make sure to add a meta charset tag in your <code>&lt;head&gt;</code> section using the <code>&lt;meta charset="UTF-8"&gt;</code> attribute to ensure proper text rendering across all browsers.',

    'audits.test.deprecated_html_tags' => 'Deprecated HTML tags',
    'audits.test.deprecated_html_tags_help' => 'Deprecated HTML tags are outdated elements no longer recommended for use, as they are replaced by modern alternatives to improve web standards and functionality.',
    'audits.test.deprecated_html_tags_count' => '%s deprecated tags',
    'audits.test.deprecated_html_tags_missing' => 'No deprecated tags found.',
    'audits.test.deprecated_html_tags.existing' => 'Deprecated tags found.',
    'audits.test.deprecated_html_tags.existing_help' => 'Remove deprecated tags to prevent rendering issues & improve compatibility with modern browsers, which helps search engines index your content effectively & user experience.',

    'audits.test.header_server' => 'Server tag',
    'audits.test.header_server_missing' => 'No server header tag has been found.',
    'audits.test.header_server_help' => 'This header tag should not be included in your webpage to avoid being used by attackers to find potential vulnerabilities.',
    'audits.test.header_server.existing' => 'Server tag is public.',
    'audits.test.header_server.existing_help' => 'Make sure to remove the <strong>server</strong> HTTP header tag to avoid exposing details about your server.',

    'audits.test.server_compression' => 'Server compression',
    'audits.test.server_compression_comparison' => '%1$s non-compressed vs %2$s compressed (%3$s%% difference)',
    'audits.test.server_compression_help' => 'Server compression, like gzip or Brotli, reduces the size of web resources, leading to faster load times. ',
    'audits.test.server_compression.missing' => 'No compression algorithm found.',
    'audits.test.server_compression.missing_help' => 'Make sure to enable server response compression with modern algorithms, such as <strong>brotli</strong> or <strong>gzip</strong>.',

    'audits.test.doctype' => 'Doctype declaration',
    'audits.test.doctype_help' => 'The doctype declaration tells the browser about what document type to expect.',
    'audits.test.doctype.missing' => 'Doctype is missing.',
    'audits.test.doctype.missing_help' => 'Make sure to add the <code>&lt;!DOCTYPE html&gt;</code> snippet to the start of your HTML webpage content.',

    'audits.test.social_links' => 'Social links',
    'audits.test.social_links_count' => '%s socials',
    'audits.test.social_links_text_missing' => 'No text content',
    'audits.test.social_links.missing' => 'Social links are missing.',
    'audits.test.social_links.missing_help' => 'We have not found any relevant social links on this webpage.',

    'audits.test.words_count' => 'Words counts',
    'audits.test.words_count_count' => '%s words',
    'audits.test.words_count_help' => 'It is significant to have at least 300-500 words on your webpage. Ideally longer (1,000-2,500 words) & high quality content performs even better.',
    'audits.test.words_count.too_few' => 'Too few words.',
    'audits.test.words_count.too_few_help' => 'Make sure to create more content for your webpage. Aim for at least <strong>300-500 words</strong> on your webpage.',

    'audits.test.words_used' => 'Top used words',
    'audits.test.words_used_count' => 'Top %s keywords',

    'audits.test.emails' => 'Plaintext emails',
    'audits.test.emails_help' => 'Plaintext emails on webpages are bad because they can be easily scraped by bots, leading to spam.',
    'audits.test.emails_count' => '%s emails',
    'audits.test.emails_missing' => 'No plaintext emails found.',
    'audits.test.emails.existing' => 'Plaintext emails found.',
    'audits.test.emails.existing_help' => 'Remove or replace all plaintext emails from your webpage to prevent spam & abuse by bots.',

    'audits.test.text_to_html_ratio' => 'Text to HTML ratio',
    'audits.test.text_to_html_ratio_help' => 'A higher text-to-HTML ratio signals valuable content, efficient coding, and better user experience, all boosting SEO rankings.',
    'audits.test.text_to_html_ratio.too_low' => 'Text to HTML ratio is too low.',
    'audits.test.text_to_html_ratio.too_low_help' => 'It is good to have a higher than 15% text to HTML ratio.',

    'audits.test.is_https' => 'Secure URL (HTTPS)',
    'audits.test.is_https_help' => 'HTTPS secures data with encryption, boosts trust, and improves SEO rankings as search engines favor safe websites.',
    'audits.test.is_https.missing' => 'No HTTPS encryption.',
    'audits.test.is_https.missing_help' => 'It is important to get an SSL certificate for your domain.',

    'audits.test.is_ssl_valid' => 'Valid SSL Certificate',
    'audits.test.is_ssl_valid_help' => 'A valid SSL certificate ensures secure connections, builds user trust, and prevents warnings in browsers.',
    'audits.test.is_ssl_valid.invalid' => 'Invalid or expired SSL certificate.',
    'audits.test.is_ssl_valid.invalid_help' => 'Renew or replace your SSL certificate to maintain website security and trustworthiness.',

    'audits.test.inline_css' => 'Inline CSS',
    'audits.test.inline_css_help' => 'Using inline CSS can make your webpage harder to maintain and may negatively impact loading performance and SEO.',
    'audits.test.inline_css_count' => '%s inline styles found',
    'audits.test.inline_css_missing' => 'No inline CSS found.',
    'audits.test.inline_css.existing' => 'Inline CSS found.',
    'audits.test.inline_css.existing_help' => 'Avoid using inline CSS. Move styles to external stylesheets for better performance and maintainability.',

    'audits.test.image_formats' => 'Image formats',
    'audits.test.image_formats_help' => 'AVIG, WebP and SVG optimize SEO by reducing image sizes for faster loading, maintaining quality, and enhancing user experience with modern browser support.',
    'audits.test.image_formats_count' => '%s unoptimized images found',
    'audits.test.image_formats_title_missing' => 'No title set',
    'audits.test.image_formats_missing' => 'All images use the WebP, AVIF or SVG modern formats.',
    'audits.test.image_formats.existing' => 'Unoptimized images found.',
    'audits.test.image_formats.existing_help' => 'Convert your images to WebP, AVIF or SVG formats.',

    'audits.test.image_alt' => 'Image alt attributes',
    'audits.test.image_alt_help' => 'Alt attributes improve SEO by describing images for search engines, enhancing accessibility for visually impaired users, and ensuring proper content indexing.',
    'audits.test.image_alt_count' => '%s images missing alt attribute',
    'audits.test.image_alt_title_missing' => 'No title set',
    'audits.test.image_alt_existing' => 'All images have the <code>alt</code> attribute.',
    'audits.test.image_alt.missing' => 'Images with missing alt attributes found.',
    'audits.test.image_alt.missing_help' => 'Add descriptive alt attributes to your images for better SEO and accessibility.',

    'audits.test.image_lazy_loading' => 'Lazy loading images',
    'audits.test.image_lazy_loading_help' => 'The <code>loading="lazy"</code> attribute improves SEO and page speed by deferring the loading of images until they are visible in the viewport, reducing initial page load time.',
    'audits.test.image_lazy_loading_count' => '%s images missing lazy loading',
    'audits.test.image_lazy_loading_title_missing' => 'No title set',
    'audits.test.image_lazy_loading_existing' => 'All images use the <code>loading="lazy"</code> attribute.',
    'audits.test.image_lazy_loading.missing' => 'Images without lazy loading found.',
    'audits.test.image_lazy_loading.missing_help' => 'Add the <code>loading="lazy"</code> attribute to your images to improve page performance and SEO. <strong>Only use this attribute for images below-the-fold.</strong>',

    'audits.test.other_headings' => 'Other headings',
    'audits.test.other_headings_help' => 'H2 to H6 headings should be used across your webpage to properly structure your content, improve readability and help search engines to understand your webpage structure.',
    'audits.test.other_headings_count' => '%1$s %2$s tags',

    'audits.test.canonical' => 'Canonical URL',
    'audits.test.canonical_help' => 'The canonical tag prevents duplicate content by specifying the preferred URL, resolving issues with query parameters, non-www, and www versions and other potential issues.',
    'audits.test.canonical.missing' => 'Canonical tag is missing.',
    'audits.test.canonical.missing_help' => 'Make sure to add the link tag in your <code>&lt;head&gt;</code> section using the <code>&lt;rel="canonical"&gt;</code> attribute.',
    'audits.test.canonical.missing_help2' => 'If the audited URL is the main version of the webpage, it would look like this: %s',

    'audits.test.is_seo_friendly_url' => 'SEO friendly URL',
    'audits.test.is_seo_friendly_url_help' => 'SEO-friendly URLs are clean, readable, lowercase, and use hyphens without special characters or query strings.',
    'audits.test.is_seo_friendly_url.false' => 'URL is not search engine optimized.',
    'audits.test.is_seo_friendly_url.false_help' => 'Make sure to remove any uppercase or special characters, only use hyphens to separate words & convert any potential query strings to a readable and clean format if possible.',

    'audits.test.is_http2' => 'HTTP/2 enabled',
    'audits.test.is_http2_help' => 'HTTP/2 improves website performance by enabling faster page load times and better resource handling, enhancing user experience and SEO.',
    'audits.test.is_http2.missing' => 'HTTP/2 is not enabled.',
    'audits.test.is_http2.missing_help' => 'Enable HTTP/2 support on your server for faster performance and improved SEO benefits.',

    'audits.test.unsafe_external_links' => 'Unsafe external links',
    'audits.test.unsafe_external_links_help' => 'External links with <code>target="_blank"</code> should include <code>noopener</code> or <code>noreferrer</code> to prevent potential security vulnerabilities.',
    'audits.test.unsafe_external_links_count' => '%s unsafe links',
    'audits.test.unsafe_external_links_text_missing' => 'No text content',
    'audits.test.unsafe_external_links_missing' => 'All links are safe.',
    'audits.test.unsafe_external_links.existing' => 'Unsafe links found.',
    'audits.test.unsafe_external_links.existing_help' => 'Make sure to add the <code>rel="noopener"</code> or <code>rel="noreferrer"</code> attribute to the link tag to avoid potential security issues.',

    'audits.test.non_deferred_scripts' => 'Non-deferred javascript',
    'audits.test.non_deferred_scripts_help' => 'JavaScript scripts should use the <code>defer</code> attribute to avoid blocking the rendering of the page.',
    'audits.test.non_deferred_scripts_count' => '%s scripts without defer',
    'audits.test.non_deferred_scripts_src_missing' => 'Embedded script tag',
    'audits.test.non_deferred_scripts_missing' => 'All scripts are properly deferred.',
    'audits.test.non_deferred_scripts.existing' => 'Non-deferred scripts found.',
    'audits.test.non_deferred_scripts.existing_help' => 'Add the <code>defer</code> attribute to JavaScript script tags to improve page load performance and prevent render-blocking issues.',
    'audits.test.non_deferred_scripts.existing_help2' => 'If your scripts are located at the most bottom of your webpage, you can ignore those.',

    'audits.test.http_requests' => 'HTTP requests',
    'audits.test.http_requests_help' => 'HTTP requests are calls a webpage makes to fetch resources (e.g., images, CSS, JS), and too many slow down loading, negatively impacting SEO and user experience.',
    'audits.test.http_requests_count' => '%s total HTTP requests found',
    'audits.test.http_requests_css' => '%s CSS files requested',
    'audits.test.http_requests_js' => '%s JS files requested',
    'audits.test.http_requests_images' => '%s images requested',
    'audits.test.http_requests_videos' => '%s video files requested',
    'audits.test.http_requests_audios' => '%s audio files requested',
    'audits.test.http_requests_iframes' => '%s iframes requested',
    'audits.test.http_requests.too_many' => 'Too many HTTP requests.',
    'audits.test.http_requests.too_many_help' => 'Consider optimizing your assets by minifying, combining files, and using CDNs where possible to improve page performance.',

    'audits.test.internal_links' => 'Internal links',
    'audits.test.internal_links_help' => 'Internal links connect pages within your website, helping search engines understand site structure and navigation. Too many internal links can dilute their impact and confuse crawlers.',
    'audits.test.internal_links_text_missing' => 'No text content',
    'audits.test.internal_links_count' => '%s internal links found',
    'audits.test.internal_links.too_many' => 'Too many internal links.',
    'audits.test.internal_links.too_many_help' => 'Reduce internal links to below 100 for better SEO and crawl efficiency.',

    'audits.test.external_links' => 'External links',
    'audits.test.external_links_help' => 'External links point to other websites and can enhance content credibility, but too many dilute your page’s authority and may harm SEO.',
    'audits.test.external_links_text_missing' => 'No text content',
    'audits.test.external_links_count' => '%s external links found',
    'audits.test.external_links.too_many' => 'Too many external links.',
    'audits.test.external_links.too_many_help' => 'Limit external links to 25 or fewer to retain page authority.',

    'audits.test.opengraph' => 'Open graph',
    'audits.test.opengraph_help' => 'Open Graph tags optimize how your content appears on social media platforms, enhancing click-through rates and traffic.',
    'audits.test.opengraph_count' => '%s open graph tags',
    'audits.test.opengraph.missing' => 'Open Graph tags are missing.',
    'audits.test.opengraph.missing_help' => 'Add essential Open Graph tags like og:title, og:description, og:image, and og:url to improve social media sharing and user engagement.',

    'audits.input.sitemap_url_placeholder' => 'https://example.com/sitemap.xml',
    'audits.input.html' => 'HTML',
    'audits.input.html_help' => 'Insert the full HTML source code that you wish to get audited.',
    'audits.input.html_placeholder' => 'Full HTML source code',
    'audits.input.html_url_help' => 'Full URL be used to only test the site Headers, Not found page, Robots file. The content audit will be based on the custom inserted HTML code.',
    'audits.input.bulk_url_help' => 'Insert one URL per line.',
    'audits.input.bulk_url_placeholder1' => 'https://example.com/page1',
    'audits.input.bulk_url_placeholder2' => 'https://example.com/page2',
    'audits.input.type.single' => 'Single webpage',
    'audits.input.type.single_help' => 'Submit a single webpage URL for auditing.',
    'audits.input.type.sitemap' => 'Sitemap',
    'audits.input.type.sitemap_help' => 'Submit a sitemap URL and parse URLs within that sitemap.',
    'audits.input.type.bulk' => 'Bulk',
    'audits.input.type.bulk_help' => 'Submit multiple URLs to be audited at once.',
    'audits.input.type.html' => 'HTML',
    'audits.input.type.html_help' => 'Submit raw HTML to be audited manually.',
    'audits.input.is_public' => 'Public audit',
    'audits.input.is_public_help' => 'Set the visibility of the audit.',
    'audits.input.password_help' => 'Set a password for your audit page. Leave empty to disable.',
    'audits.input.domain_id' => 'Custom domain',
    'audits.input.domain_id_help' => 'Use a custom domain for your audit pages.',
    'audits.input.audit_check_interval' => 'Audit check interval',
    'audits.input.audit_check_interval_help' => 'Setup automatic audit refresh and processing.',
    'audits.input.notification_handlers' => 'Notifications',
    'audits.input.notification_handlers_help' => 'Get notified when your audit gets refreshed.',

    'audits.password.title' => 'Password protected',
    'audits.password.header' => 'Password protected',
    'audits.password.subheader' => 'You must input the correct password to see the data. Your password will be remembered for 30 days.',
    'audits.password.error_message' => 'The password is incorrect.',

    'audits.error_message.invalid_response_code' => 'The webpage responded with a %s status code. A 200 (OK) status code is required to initiate the audit process.',
    'audits.error_message.invalid_html' => 'The provided webpage contains invalid HTML content.',
    'audits.error_message.blacklisted_domain' => 'This domain is blacklisted.',

    'audits.success_message.processed_sitemap' => '%1$s sitemap has processed %2$s links successfully.',
    'audits.success_message.processed_bulk' => 'We have processed %s links successfully.',
    'audits.success_message.processed_refresh' => '%s audit has been refreshed successfully.',

    'audits.simple_notification' => 'Audit has been refreshed \'%1$s\' and got a %2$s%% score with %3$s%% total issues.%4$sView details: %4$s 🔗.',
    'audits.push_notification.title' => 'Audit refreshed (%s%% score)',
    'audits.push_notification.description' => '%1$s',


    'audit_refresh_modal.header' => 'Audit refresh',
    'audit_refresh_modal.subheader' => 'Current audit data will be archived and be replaced by freshly generated one.',


    'audit.title' => 'Audit - %s',
    'audit.menu' => 'Audit',
    'audit.breadcrumb' => 'Audit',
    'audit.header' => '%s',


    'audit_update.breadcrumb' => 'Edit audit',
    'audit_update.title' => 'Edit audit',
    'audit_update.header' => 'Edit audit',


    'seo.title' => 'Search Engine Optimization Checker',
    'seo.meta_description' => '',
    'seo.meta_keywords' => '',
    'seo.menu' => 'SEO Checker',
    'seo.header' => 'SEO Checker',
    'seo.subheader' => 'Generate SEO audits for any HTML webpage.',
    'seo.extra_content' => 'Custom content block. Change me from the language manager in the admin panel.',


    'notification_handlers.title' => 'Notification handlers',
    'notification_handlers.menu' => 'Notification handlers',
    'notification_handlers.breadcrumb' => 'Notification handlers',
    'notification_handlers.header' => 'Notification handlers',
    'notification_handlers.subheader' => 'How do you want to get notified when certain events happen?',
    'notification_handlers.create' => 'Create notification handler',


    'notification_handlers.input.name' => 'Name',
    'notification_handlers.input.type' => 'Notification type',
    'notification_handlers.input.type_x' => 'X tweet',
    'notification_handlers.input.type_email' => 'Email',
    'notification_handlers.input.type_webhook' => 'Webhook',
    'notification_handlers.input.type_slack' => 'Slack',
    'notification_handlers.input.type_microsoft_teams' => 'Microsoft Teams',
    'notification_handlers.input.type_discord' => 'Discord',
    'notification_handlers.input.type_telegram' => 'Telegram',
    'notification_handlers.input.type_twilio' => 'SMS',
    'notification_handlers.input.type_twilio_call' => 'Phone call',
    'notification_handlers.input.type_whatsapp' => 'Whatsapp',
    'notification_handlers.input.type_push_subscriber_id' => 'Push notification',
    'notification_handlers.input.push_subscriber_id' => 'Push subscriber',
    'notification_handlers.input.push_subscriber_id_help' => 'Select one device that you have subscribed with.',
    'notification_handlers.input.email' => 'Email',
    'notification_handlers.input.email_help' => 'Receive email notifications.',
    'notification_handlers.input.webhook' => 'Webhook URL',
    'notification_handlers.input.webhook_help' => 'Receive POST calls notifications to your specified webhook URL.',
    'notification_handlers.input.slack' => 'Slack webhook URL',
    'notification_handlers.input.slack_help' => 'Receive Slack notifications for your specified Slack channel via webhooks. <a href="https://slack.com/apps/A0F7XDUAZ-incoming-webhooks" target="_blank">Get Slack webhook URL</a>.',
    'notification_handlers.input.discord' => 'Discord webhook URL',
    'notification_handlers.input.discord_help' => 'Receive Discord notifications for your specified Discord channel via webhooks.',
    'notification_handlers.input.telegram' => 'Telegram API Token',
    'notification_handlers.input.telegram_help' => 'The token for the HTTP API that you received after creating the bot on Telegram.',
    'notification_handlers.input.telegram_chat_id' => 'Telegram Chat ID',
    'notification_handlers.input.telegram_chat_id_help' => 'Where the bot should send the messages to.',
    'notification_handlers.input.twilio' => 'Phone number',
    'notification_handlers.input.twilio_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.input.twilio_call' => 'Phone number',
    'notification_handlers.input.twilio_call_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.input.whatsapp' => 'Whatsapp number',
    'notification_handlers.input.whatsapp_help' => 'Example of valid phone number: 15558675310. Only numbers.',
    'notification_handlers.input.x_consumer_key' => 'X consumer key',
    'notification_handlers.input.x_consumer_secret' => 'X consumer secret',
    'notification_handlers.input.x_access_token' => 'X access token',
    'notification_handlers.input.x_access_token_secret' => 'X access token secret',
    'notification_handlers.input.is_enabled' => 'Notification handler is active',
    'notification_handlers.no_data' => 'There are no notification handlers for now',
    'notification_handlers.no_data_help' => 'Start by creating your first notification handler.',


    'notification_handler_create.breadcrumb' => 'Create a new notification handler',
    'notification_handler_create.title' => 'Create a new notification handler',
    'notification_handler_create.header' => 'Create a new notification handler',


    'notification_handler_update.breadcrumb' => 'Edit notification handler',
    'notification_handler_update.title' => 'Edit notification handler',
    'notification_handler_update.header' => 'Edit notification handler',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your audits links.',
    'domains.create' => 'Connect domain',
    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',
    'domains.input.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.input.host' => 'Domain or subdomain',
    'domains.input.custom_index_url' => 'Custom index URL',
    'domains.input.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.input.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.input.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the data associated with the domain will be lost, including all the links associated with it. This action cannot be undone.',


    'tools.breadcrumb' => 'Tools',
    'tools.title' => 'Tools',
    'tools.tool_title' => '%s - Tools',
    'tools.menu' => 'Tools',
    'tools.header' => 'Tools',
    'tools.subheader' => 'Extra web tools that are helpful and related to the services we provide.',
    'tools.total_views' => 'Total views',
    'tools.total_submissions' => 'Total submissions',
    'tools.popular_tools' => 'Popular tools',
    'tools.similar_tools' => 'Similar tools',
    'tools.share' => 'Share',
    'tools.result' => 'Result',
    'tools.last_submissions' => 'Last submissions',

    'tools.dns_lookup.name' => 'DNS Lookup',
    'tools.dns_lookup.description' => 'Find A, AAAA, CNAME, MX, NS, TXT, SOA DNS records of a host.',
    'tools.dns_lookup.meta_keywords' => '',
    'tools.dns_lookup.host' => 'Host',
    'tools.dns_lookup.error_message' => 'We could not retrieve any DNS records for your given host.',
    'tools.dns_lookup.result.host' => 'Host',
    'tools.dns_lookup.result.ttl' => 'TTL',
    'tools.dns_lookup.result.target' => 'Target',
    'tools.dns_lookup.result.ipv6' => 'IPv6',
    'tools.dns_lookup.result.priority' => 'Priority',
    'tools.dns_lookup.result.entries' => 'Entries',
    'tools.dns_lookup.result.mname' => 'MNAME',
    'tools.dns_lookup.result.rname' => 'RNAME',
    'tools.dns_lookup.result.serial' => 'Serial',
    'tools.dns_lookup.result.refresh' => 'Refresh',
    'tools.dns_lookup.result.retry' => 'Retry',
    'tools.dns_lookup.result.expire' => 'Expire',
    'tools.dns_lookup.result.minimum_ttl' => 'Min. TTL',
    'tools.dns_lookup.result.flags' => 'Flags',
    'tools.dns_lookup.result.tag' => 'Tag',
    'tools.dns_lookup.result.value' => 'Value',
    'tools.dns_lookup.result.ns' => 'Nameserver',
    'tools.dns_lookup.result.x_records' => '%s records',
    'tools.dns_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.ip_lookup.name' => 'IP Lookup',
    'tools.ip_lookup.description' => 'Get approximate IP details.',
    'tools.ip_lookup.meta_keywords' => '',
    'tools.ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.ip_lookup.result.latitude' => 'Latitude',
    'tools.ip_lookup.result.longitude' => 'Longitude',
    'tools.ip_lookup.result.timezone' => 'Timezone',
    'tools.ip_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.ssl_lookup.name' => 'SSL Lookup',
    'tools.ssl_lookup.description' => 'Get all possible details about an SSL certificate.',
    'tools.ssl_lookup.meta_keywords' => '',
    'tools.ssl_lookup.host' => 'Host',
    'tools.ssl_lookup.port' => 'Port',
    'tools.ssl_lookup.error_message' => 'We could not retrieve any details for your given host.',
    'tools.ssl_lookup.result.organization' => 'Organization',
    'tools.ssl_lookup.result.common_name' => 'Common name',
    'tools.ssl_lookup.result.start_datetime' => 'Issued on',
    'tools.ssl_lookup.result.end_datetime' => 'Expiring on',
    'tools.ssl_lookup.result.signature_type' => 'Signature type',
    'tools.ssl_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.whois_lookup.name' => 'Whois Lookup',
    'tools.whois_lookup.description' => 'Get all possible details about a domain name.',
    'tools.whois_lookup.meta_keywords' => '',
    'tools.whois_lookup.domain_name' => 'Domain name',
    'tools.whois_lookup.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.whois_lookup.result.nameservers' => 'Nameservers',
    'tools.whois_lookup.result.registrar' => 'Registrar',
    'tools.whois_lookup.result.start_datetime' => 'Issued on',
    'tools.whois_lookup.result.end_datetime' => 'Expiring on',
    'tools.whois_lookup.result.updated_datetime' => 'Updated on',
    'tools.whois_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.ping.name' => 'Ping',
    'tools.ping.description' => 'Website status checker.',
    'tools.ping.meta_keywords' => '',
    'tools.ping.target_url' => 'URL',
    'tools.ping.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.ping.result.is_ok' => 'Online',
    'tools.ping.result.is_not_ok' => 'Offline',
    'tools.ping.result.response_time' => 'Response time',
    'tools.ping.result.response_status_code' => 'Response status code',
    'tools.ping.result.error' => 'Error',
    'tools.ping.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.google_cache_checker.name' => 'Google cache checker',
    'tools.google_cache_checker.description' => 'Check if the URL is cached or not by Google.',
    'tools.google_cache_checker.meta_keywords' => '',
    'tools.google_cache_checker.result' => 'Result',
    'tools.google_cache_checker.result.cached' => 'This URL is cached (%s).',
    'tools.google_cache_checker.result.not_cached' => 'This URL is not cached.',
    'tools.google_cache_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.google_cache_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.meta_tags_checker.name' => 'Meta tags checker',
    'tools.meta_tags_checker.description' => 'Get & verify the meta tags of any website.',
    'tools.meta_tags_checker.meta_keywords' => '',
    'tools.meta_tags_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.meta_tags_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.website_hosting_checker.name' => 'Website hosting checker',
    'tools.website_hosting_checker.description' => 'Get the web-host of a given website.',
    'tools.website_hosting_checker.meta_keywords' => '',
    'tools.website_hosting_checker.host' => 'Host',
    'tools.website_hosting_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.website_hosting_checker.result.isp' => 'ISP',
    'tools.website_hosting_checker.result.org' => 'Organization',
    'tools.website_hosting_checker.result.latitude' => 'Latitude',
    'tools.website_hosting_checker.result.longitude' => 'Longitude',
    'tools.website_hosting_checker.result.timezone' => 'Timezone',
    'tools.website_hosting_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.http_headers_lookup.name' => 'HTTP headers lookup',
    'tools.http_headers_lookup.description' => 'Get all the HTTP headers that an URL returns for a typical GET request.',
    'tools.http_headers_lookup.meta_keywords' => '',
    'tools.http_headers_lookup.error_message' => 'We could not get any information for your entered URL.',
    'tools.http_headers_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.http2_checker.name' => 'HTTP/2 Checker',
    'tools.http2_checker.description' => 'Check whether a website is using the new HTTP/2 protocol or not.',
    'tools.http2_checker.meta_keywords' => '',
    'tools.http2_checker.error_message' => 'We could not get any information for your entered URL.',
    'tools.http2_checker.success_message.disabled' => 'HTTP/2 is disabled.',
    'tools.http2_checker.success_message.enabled' => 'HTTP/2 is enabled.',
    'tools.http2_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.brotli_checker.name' => 'Brotli Checker',
    'tools.brotli_checker.description' => 'Check whether a website is using the Brotli Compression algorithm or not.',
    'tools.brotli_checker.meta_keywords' => '',
    'tools.brotli_checker.error_message' => 'We could not get any information for your entered URL.',
    'tools.brotli_checker.success_message.disabled' => 'Brotli is disabled.',
    'tools.brotli_checker.success_message.enabled' => 'Brotli is enabled.',
    'tools.brotli_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.url_redirect_checker.name' => 'URL redirect checker',
    'tools.url_redirect_checker.description' => 'Check for 301 & 302 redirects of a specific URL. It will check for up to 10 redirects.',
    'tools.url_redirect_checker.meta_keywords' => '',
    'tools.url_redirect_checker.status_code' => 'Status code',
    'tools.url_redirect_checker.result' => 'Result',
    'tools.url_redirect_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.url_redirect_checker.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.reverse_ip_lookup.name' => 'Reverse IP Lookup',
    'tools.reverse_ip_lookup.description' => 'Take an IP and try to look for the domain/host associated with it.',
    'tools.reverse_ip_lookup.meta_keywords' => '',
    'tools.reverse_ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.reverse_ip_lookup.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

];
